//
// Fragment shader for Stars effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time;
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;

const float PI = 3.1415926;

vec2 rotate(float a, vec2 p)
{
    return vec2(cos(a) * p.x + sin(a) * p.y,
                cos(a) * p.y - sin(a) * p.x);
}
float starsLayer(vec2 p)
{
    p *= vec2(4.0, 3.0);
    return clamp(1e-2 / abs(cos(p.x) * sin(p.y)) * cos(p.x + PI * 0.5) * sin(p.y + PI * 0.5), 0.0, 1.0);
}
vec3 stars(vec2 p)
{
    vec2 p2 = floor(p * 100.0) / 100.0;
    
    float b = fract(atan(p2.y, p2.x) / PI * 10.0 + length(p2) * 3.0 * cos(time * 0.3) + cos(time * 0.5) * 2.0);
    
    b = smoothstep(0.4, 0.5, b) - smoothstep(0.9, 1.0, b);
    
    b *= (0.8 + 0.2 * cos(p.y * 200.0 * PI)) * (0.95 + 0.05 * cos(time * 40.0));
    
    return vec3(b) * 0.1 + vec3(starsLayer(rotate(-0.9, p * 4.0) + vec2(time * 0.1)) * 0.1 +
                                starsLayer(rotate(0.1, p + vec2(time * 0.1))) +
                                starsLayer(rotate(1.0, p * 2.0 + vec2(time * 0.1)))) * vec3(1.0, 1.2, 1.3) * 0.5;
}

float vignette(vec2 p)
{
    return 1.0 - (p.x * p.x * p.x * p.x  + p.y * p.y * p.y * p.y) * 0.5;
}

void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);

        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;

        vec2 v;
        v.x = -1.0 + 2.0/drawingBoundsWidth*(pCoord.x-drawingBoundsOrigin.x);
        v.y = -1.0 + 2.0/drawingBoundsHeight*(pCoord.y-drawingBoundsOrigin.y);
        

        vec3 starColor= stars(v) * smoothstep(0.0, 0.4, length(v));
        starColor *= vignette(v);

        vec4 outColor = texture2DRect(texUnit, gUV);
          
        gl_FragColor.rgb = mix(outColor.rgb, starColor, 0.35);
        gl_FragColor.a = outColor.a;
        gl_FragColor= modulateColor*gl_FragColor;
    }
}

